<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

/**
 * Class Skooly
 */
class Skooly
{
    /**
     * @var $api_key
     * @var $shortcode
     * @var $partner_id
     * @var $api_endpoint
     * @var $account_balance_endpoint
     * @var $delivery_report_endpoint
     */
    protected static $api_key;
    protected static $shortcode;
    protected static $partner_id;
    protected static $api_endpoint = "https://isms.celcomafrica.com/api/services/sendsms/";
    protected static $account_balance_endpoint = "https://isms.celcomafrica.com/api/services/getbalance/";
    protected static $delivery_report_endpoint = 'https://isms.celcomafrica.com/api/services/getdlr/';

    public static function init($api_key, $shortcode, $partner_id)
    {  
        self::$shortcode = $shortcode;
        self::$api_key = $api_key;
        self::$partner_id = $partner_id;
    }

    /**
     * @param $mobile
     * @param $message
     * @param string $method
     * @return mixed
     */
    public static function send($mobile, $message, $name, $method = "POST")
    {
        if (substr($mobile, 0, 1) == "+") {
            $mobile = str_replace("+", "", $mobile);
        }
        if (substr($mobile, 0, 1) == "0") {
            $mobile = preg_replace("/^0/", "254", $mobile);
        }
        if (substr($mobile, 0, 1) == "7") {
            $mobile = "254{$mobile}";
        }
    
        $retry_count = 0;
        $max_retries = 3;
        $success = false;
    
        if ($method == 'GET') {
            $request = "?apikey=" . urlencode(self::$api_key) .
                       "&partnerID=" . urlencode(self::$partner_id) .
                       "&message=" . urlencode($message) .
                       "&shortcode=" . self::$shortcode .
                       "&mobile=" . $mobile;
    
            while (!$success && $retry_count < $max_retries) {
                $response = self::send_get_request($request);
    
                if ($response && isset($response['responses'][0]['response-description']) &&
                    $response['responses'][0]['response-description'] == 'Success') {
                    $success = true;
                } else {
                    $retry_count++;
                    sleep(1); 
                }
            }
    
        } else {
            $request = array(
                'apikey'    => self::$api_key,
                'partnerID' => self::$partner_id,
                'shortcode' => self::$shortcode,
                'message'   => $message,
                'mobile'    => $mobile
            );
            $request_json = json_encode($request);
    
            while (!$success && $retry_count < $max_retries) {
                $response = self::send_post_request($request_json);
    
                if ($response && isset($response['responses'][0]['response-description']) &&
                    $response['responses'][0]['response-description'] == 'Success') {
                    $success = true;
                } else {
                    $retry_count++;
                    sleep(1);
                }
            }
        }
    
        if ($response) {
            if (isset($response['responses'][0]['response-code']) && $response['responses'][0]['response-code'] === 200) {
                $stdat = array(
                    'usertypeID'        => '0',
                    'users'             => $name,
                    'type'              => ucfirst('automated'),
                    'message'           => $message,
                    'year'              => date('Y'),
                    'senderusertypeID'  => 1,
                    'senderID'          => self::$shortcode
                );
    
                $ci = &get_instance();
                $ci->load->model("mailandsms_m");
                $ci->mailandsms_m->insert_mailandsms($stdat);
    
                self::account_balance();
            }
        }
    
        return true;
    }
    
    /**
     * @param $request
     * @return mixed
     */
    public static function send_post_request($request){
        $url = self::$api_endpoint;
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json')) ;
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $request);
        $response = curl_exec($curl);
        $result = json_decode($response,true);
        return $result;
        
    }

    /**
     * @param $request
     * @return mixed
     */
    public static function send_get_request($request){
        $url = self::$api_endpoint.$request;
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER, false,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 600,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Cookie: PHPSESSID=6us2eiq36hb133dfju55kfbill'
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $result = json_decode($response,true);
        return $result;
           
    }

    /**
     * @param $message_id
     * @return mixed
     */
    public static function delivery_report($message_id){
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, self::$delivery_report_endpoint);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json')); //setting custom header
        $request = array(
            //Fill in the request parameters with valid values
            'partnerID' => self::$partner_id,
            'apikey' => self::$api_key,
            'messageID' => $message_id,
        );
        $data_string = json_encode($request);

        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);

        $response = curl_exec($curl);
        $result = json_decode($response,true);
        return $result;
    }

    /**
     * @return mixed
     */
    public static function account_balance(){
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, self::$account_balance_endpoint);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json')); //setting custom header
        $request = array(
            'partnerID' => self::$partner_id,
            'apikey' => self::$api_key,
        );

        $data_string = json_encode($request);

        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);

        $response = curl_exec($curl);
        $result = json_decode($response,true);

        if($result['response-code'] === 200){
            $ci     = &get_instance();
            $ci->load->model("smssettings_m");

            $array = array(            
                array(
                    'field_names' => 'celcom_balance',
                    'field_values' => $result['credit']
                )
            );

            $ci->smssettings_m->update_celcom($array);
        }        

       return $result ;
    }

    /**
     * @param $message
     * @param $mobile
     * @param $time
     * @return mixed
     */
    public static function schedule($message, $mobile, $time){
        if(get_setting('system_notification')){
            $request = array(
                'apikey'=>self::$api_key,
                'partnerID'=>self::$partner_id,
                'shortcode'=>self::$shortcode,
                'message'=>$message ,
                'mobile'=>$mobile ,
                'timeToSend'=>$time /*timestamp or datetime*/
            );

            $request = json_encode($request); /*convert to json for processing*/
            $response = self::$send_post_request($request);
            return $response;
        }

        return [];
        
    }

    /**
     * @param $data
     * @param $term
     * @param $message
     * @return mixed|string
     */
    public static function customize_message($data, $term, $message){
        if(!$message){
            return "";
        }
        $term_index = str_replace("{",'',str_replace("}",'',$term));
        if(array_key_exists($term_index,$data)){
            $message = str_replace($term,$data[$term_index],$message);
        }
        return $message;
    }
}